import UIKit

class ViewController: UIViewController
{
    var redBox: UIView!
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        redBox = UIView(frame: CGRect(x: 0,
                                      y: 0,
                                      width: 200,
                                      height: 200))
        
        redBox.center = self.view.center
        self.view.addSubview(redBox)
        redBox.backgroundColor = UIColor.red
        redBox.isUserInteractionEnabled = true
        redBox.isMultipleTouchEnabled = true
    }

    
    override func touchesMoved(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        if touches.count == 1
        {   // rotate
            let touchOne = touches.first
            
            if ( touchOne?.view != redBox) {
                return
            }
            
            let newRotation = rotateAction(touch: touchOne!,
                                           view: self.view)
            
            redBox.transform = redBox.transform.rotated(by: newRotation)
        }
        else if touches.count == 2
        {   // scale
            let touchesArr = Array (touches)
            
            let touchOne = touchesArr[0]
            let touchTwo = touchesArr[1]
            
            if ( touchOne.view != redBox && touchTwo.view != redBox) {
                return
            }
            
            let newRatio = scaleAction(inpTouchOne: touchOne,
                                       inpTouchTwo: touchTwo,
                                       inpView: self.view)
            
            redBox.transform = redBox.transform.scaledBy(x: newRatio,
                                                         y: newRatio)
        }
    }
}
